/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.serialinterface;

import ch.uyuno.serialinterface.Frame;
import ch.uyuno.serialinterface.Framing;
import ch.uyuno.serialinterface.ISerialListener;
import ch.uyuno.serialinterface.SerialDebugBufferList;
import ch.uyuno.serialinterface.SerialUtilities;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class SerialManager
implements SerialPortEventListener {
    private final int MAX_BUFFER_SIZE = 100;
    private SerialPort mySerialPort = null;
    private InputStream in;
    private OutputStream out;
    private boolean portOpen = false;
    private Set<ISerialListener> Listeners = new HashSet<ISerialListener>();
    public SerialDebugBufferList DebugBuffer = new SerialDebugBufferList();
    private Framing serialFraming;
    private byte[] receiveBuffer = new byte[100];
    private SerialUtilities.ERROR errorState;
    private static SerialManager singelton = null;

    public static SerialManager getSerialManager() {
        if (singelton == null) {
            Framing framing = new Framing();
            framing.SetCharStuf((byte)21, (byte)27);
            framing.SetChecksum(1);
            singelton = new SerialManager(framing);
        }
        return singelton;
    }

    private SerialManager(Framing framing) {
        this.serialFraming = framing;
    }

    public boolean openPort(String whichPort, int whichSpeed) {
        this.errorState = SerialUtilities.ERROR.NONE;
        this.serialFraming.InitReceive(this.receiveBuffer, 100);
        if (this.checkPort(whichPort)) {
            try {
                CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)whichPort);
                this.mySerialPort = (SerialPort)portId.open("Serial Port" + whichPort, 2000);
                try {
                    this.mySerialPort.setSerialPortParams(whichSpeed, 8, 2, 0);
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                    System.out.println("Comm parameter error: Probably an unsupported Speed");
                    this.errorState = SerialUtilities.ERROR.INIT;
                }
                try {
                    this.in = this.mySerialPort.getInputStream();
                    this.out = this.mySerialPort.getOutputStream();
                }
                catch (IOException iOException) {
                    System.out.println("couldn't establish streams for serial I/O");
                    this.errorState = SerialUtilities.ERROR.INIT;
                }
                try {
                    this.mySerialPort.addEventListener((SerialPortEventListener)this);
                    this.mySerialPort.notifyOnDataAvailable(true);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    System.out.println("couldn't add serial I/O listener");
                    this.errorState = SerialUtilities.ERROR.INIT;
                }
                this.portOpen = true;
                return this.portOpen;
            }
            catch (Exception exception) {
                System.out.println("Port in Use");
                this.errorState = SerialUtilities.ERROR.IN_USE;
                return this.portOpen;
            }
        }
        System.out.println("Did not find this Port");
        this.errorState = SerialUtilities.ERROR.NO_SUCH_PORT;
        return this.portOpen;
    }

    public void flush() {
        this.serialFraming.InitReceive(this.receiveBuffer, 100);
    }

    public boolean openPort() {
        IPreferencesService service = Platform.getPreferencesService();
        String port = service.getString("ch.uyuno.serialinterface", "ch.uyuno.serialinterface.port", "COM1", null);
        String baudrate = service.getString("ch.uyuno.serialinterface", "ch.uyuno.serialinterface.baudrate", "115200", null);
        System.out.print("Connect : ");
        System.out.print(String.valueOf(port) + " ");
        System.out.println(baudrate);
        try {
            int baud = Integer.parseInt(baudrate);
            this.openPort(port, baud);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Baudrate not Ok");
        }
        return this.portOpen;
    }

    public boolean closePort() {
        this.in = null;
        this.out = null;
        this.mySerialPort.close();
        this.portOpen = false;
        return !this.portOpen;
    }

    public SerialUtilities.ERROR getError() {
        return this.errorState;
    }

    public List<String> getPorts() {
        ArrayList<String> portsAvailable = new ArrayList<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        int numberOfPorts = 0;
        System.out.println("No.\tSerial port\tOwner");
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            portsAvailable.add(portId.getName());
            System.out.println(String.valueOf(numberOfPorts) + "\t" + portId.getName() + "\t" + portId.getCurrentOwner());
            ++numberOfPorts;
        }
        return portsAvailable;
    }

    public String[] getPortlist() {
        int numberOfPorts = 0;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        String[] ports = new String[10];
        while (portList.hasMoreElements() & numberOfPorts < 10) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            ports[numberOfPorts] = portId.getName();
            ++numberOfPorts;
        }
        String[] result = new String[numberOfPorts];
        int i = 0;
        while (i < numberOfPorts) {
            result[i] = ports[i];
            ++i;
        }
        return result;
    }

    public boolean checkPort(String portId) {
        boolean result = false;
        List<String> l = this.getPorts();
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            if (!i.next().equalsIgnoreCase(portId)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void serialEvent(SerialPortEvent event) {
        int size = 0;
        if (event.getEventType() == 1) {
            try {
                size = this.in.available();
                if (size > 0) {
                    byte[] inByte = new byte[size];
                    int res = this.serialFraming.FromReceive(inByte, size = this.in.read(inByte, 0, size));
                    if (res > 0) {
                        this.receive(new Frame(this.receiveBuffer, res));
                        this.serialFraming.InitReceive(this.receiveBuffer, 100);
                    }
                    this.DebugBuffer.DataIn(inByte, size);
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    private void receive(Frame frame) {
        Iterator<ISerialListener> iterator = this.Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().receive(frame);
        }
    }

    public void send(Frame frame) {
        byte[] outputBytes = new byte[100];
        this.serialFraming.InitTransmit(frame.GetFrameBuffer(), frame.GetFrameSize());
        int lenth = this.serialFraming.ToTransmit(outputBytes, 100);
        try {
            this.out.write(outputBytes, 0, lenth);
            this.DebugBuffer.DataOut(outputBytes, lenth);
        }
        catch (IOException iOException) {
            System.out.println("error: couldn't send string");
        }
    }

    public boolean isPortOpen() {
        return this.portOpen;
    }

    public void removeListener(ISerialListener Listener) {
        this.Listeners.remove(Listener);
    }

    public void addListener(ISerialListener Listener) {
        this.Listeners.add(Listener);
    }

    public static byte convertHexCharToByte(byte v) {
        byte result = 0;
        if (v >= 48 && v <= 57) {
            result = (byte)(v - 48);
        } else if (v >= 65 && v <= 70) {
            result = (byte)(v - 65 + 10);
        }
        return result;
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        byte[] buf1 = hexString.toUpperCase().getBytes();
        byte[] buf2 = new byte[buf1.length];
        int i = 0;
        int y = 0;
        i = 0;
        while (i < buf1.length) {
            if (buf1[i] >= 48 && buf1[i] <= 57 || buf1[i] >= 65 && buf1[i] <= 70) {
                buf2[y] = buf1[i];
                ++y;
            }
            ++i;
        }
        byte[] result = new byte[y / 2];
        i = 0;
        while (i < y / 2) {
            result[i] = (byte)(SerialManager.convertHexCharToByte(buf2[i * 2]) * 16 + SerialManager.convertHexCharToByte(buf2[i * 2 + 1]));
            ++i;
        }
        return result;
    }
}

