/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.data.Application;
import ch.uyuno.printcontrol.data.Machine;
import ch.uyuno.printcontrol.data.Utilities;
import ch.uyuno.printcontrol.server.ApplicationEntry;
import ch.uyuno.printcontrol.server.IDataAccessListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DataAccess {
    protected Machine data = new Machine();
    protected Set<IDataAccessListener> dataListeners = new HashSet<IDataAccessListener>();

    public DataAccess() {
        this.dataListeners.clear();
    }

    public void removeDataChangeListener(IDataAccessListener viewer) {
        this.dataListeners.remove(viewer);
    }

    public void addDataChangeListener(IDataAccessListener viewer) {
        this.dataListeners.add(viewer);
    }

    protected void DataChanged() {
        Iterator<IDataAccessListener> iterator = this.dataListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().DataChanged();
        }
    }

    public byte getComVersion() {
        return this.data.getComVersion();
    }

    public void setComVersion(byte comVersion) {
        this.data.setComVersion(comVersion);
    }

    public byte getFamilyType() {
        return this.data.getFamilyType();
    }

    public void setFamilyType(byte familyType) {
        this.data.setFamilyType(familyType);
    }

    public byte getSubType() {
        return this.data.getSubType();
    }

    public void setSubType(byte subType) {
        this.data.setSubType(subType);
    }

    public int getMaxNbrOfApplication() {
        return this.data.getMaxNbrOfApplication();
    }

    public void setMaxNbrOfApplication(int maxNbrOfApplication) {
        this.data.setMaxNbrOfApplication(maxNbrOfApplication);
    }

    public boolean isApplicationValied(int id) {
        return this.data.getApplication(id) != null;
    }

    public String getApplicationAsXML(int id) {
        String result = "";
        Application a = null;
        a = this.data.getApplication(id);
        if (a == null) {
            a = new Application();
        }
        result = Utilities.convertApplicationToXML((Application)a);
        return result;
    }

    public void setApplicationAsXML(int id, String xml) {
        Application a = null;
        a = Utilities.convertApplicationFromXML((String)xml);
        if (a != null && !a.isEmpty()) {
            this.data.addApplication(id, a);
            this.DataChanged();
        }
    }

    public Object[] getApplicationNameArray() {
        Application a = null;
        List pl = null;
        int maxNbrOfApplication = this.data.getMaxNbrOfApplication();
        if (maxNbrOfApplication < 1) {
            maxNbrOfApplication = 100;
        }
        Object[] result = new ApplicationEntry[maxNbrOfApplication];
        int i = 1;
        while (i <= maxNbrOfApplication) {
            result[i - 1] = new ApplicationEntry(i, "", 0);
            a = this.data.getApplication(i);
            if (a != null) {
                ((ApplicationEntry)result[i - 1]).setNr(i);
                pl = a.getParameterList();
                if (pl != null && pl.size() > 0) {
                    ((ApplicationEntry)result[i - 1]).setNbrOfParameter(pl.size());
                    ((ApplicationEntry)result[i - 1]).setName(a.getName());
                }
            }
            ++i;
        }
        return result;
    }

    public void writeToFile(String name) {
        Utilities.saveMachineToXMLFile((String)name, (Machine)this.data);
    }

    public void readFromFile(String name) {
        Machine m = Utilities.getMachineFromXMLFile((String)name);
        if (m != null) {
            this.data = m;
            this.DataChanged();
        }
    }

    public void removeApplication(int id) {
        if (this.data.removeApplication(id)) {
            this.DataChanged();
        }
    }

    public void renameApplication(int id, String name) {
        if (this.data.renameApplication(id, name)) {
            this.DataChanged();
        }
    }
}

