/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server;

import ch.uyuno.printcontrol.data.Application;
import ch.uyuno.printcontrol.data.Parameter;
import ch.uyuno.printcontrol.server.ComunicationObject;
import ch.uyuno.printcontrol.server.DataAccess;
import ch.uyuno.printcontrol.server.IMachineAccessListener;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.Utilities;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MachineAccess
extends DataAccess
implements Runnable {
    private final int MAX_TRY_TO_WRITE_APPLICATION_TO_NVRAM = 10;
    private ComunicationObject comObj;
    private STATE state;
    protected Set<IMachineAccessListener> machineListeners = new HashSet<IMachineAccessListener>();
    private boolean rm;
    private boolean wm;
    private boolean stopTransfer;
    private boolean isTransferRunning = false;
    private boolean isConnect = true;
    private boolean currentApplicationEn = false;

    public MachineAccess(ComunicationObject co) {
        this.comObj = co;
        new Thread((Runnable)this, "MachineAccess: " + co.getAddres()).start();
    }

    public void setState(STATE s) {
        this.state = s;
        if (this.state == STATE.EXIT) {
            this.noConnection();
        } else if (this.state == STATE.NO_COMMUNICATION) {
            this.isConnect = false;
        } else if (!this.isConnect) {
            this.Connection();
        }
    }

    public ComunicationObject getNewComunicationOpject() {
        return this.comObj.clone();
    }

    public STATE getState() {
        return this.state;
    }

    public boolean isTransferRunning() {
        return this.isTransferRunning;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    public void readFromMachine() {
        this.rm = true;
    }

    public void writeToMachine() {
        this.wm = true;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    private boolean testApplication(ComunicationObject co, int id) throws InterruptedException {
        boolean result = false;
        byte[] sbuf = new byte[4];
        sbuf[0] = 4;
        sbuf[1] = 1;
        sbuf[2] = (byte)id;
        if (id >= 255) {
            sbuf[3] = (byte)(id / 256);
            co.setRequest(sbuf, 4);
        } else {
            co.setRequest(sbuf, 3);
        }
        co.Prozess();
        byte[] rbuf = co.getAnser();
        if (rbuf != null) {
            if (rbuf.length >= 4) {
                if (rbuf[2] == (byte)id & rbuf[3] == id / 256) {
                    result = true;
                }
            } else if (rbuf.length >= 3 && rbuf[2] == (byte)id) {
                result = true;
            }
        }
        return result;
    }

    private boolean readApplication(ComunicationObject co, int id) throws InterruptedException {
        boolean result = false;
        byte[] sbuf = new byte[4];
        sbuf[0] = 4;
        sbuf[1] = 2;
        sbuf[2] = (byte)id;
        if (id >= 255) {
            sbuf[3] = (byte)(id / 256);
            co.setRequest(sbuf, 4);
        } else {
            co.setRequest(sbuf, 3);
        }
        co.Prozess();
        byte[] rbuf = co.getAnser();
        if (rbuf != null) {
            if (rbuf.length >= 4) {
                if (rbuf[2] == (byte)id & rbuf[3] == id / 256) {
                    result = true;
                }
            } else if (rbuf.length >= 3 && rbuf[2] == (byte)id) {
                result = true;
            }
        }
        return result;
    }

    private boolean writeApplication(ComunicationObject co, int id) throws InterruptedException {
        boolean result = false;
        int trys = 10;
        byte[] sbuf = new byte[4];
        sbuf[0] = 4;
        sbuf[1] = 3;
        sbuf[2] = (byte)id;
        if (id >= 255) {
            sbuf[3] = (byte)(id / 256);
            co.setRequest(sbuf, 4);
        } else {
            co.setRequest(sbuf, 3);
        }
        while (trys > 0 && !result) {
            co.Prozess();
            byte[] rbuf = co.getAnser();
            if (rbuf != null) {
                if (rbuf.length >= 4) {
                    if (rbuf[2] == (byte)id & rbuf[3] == id / 256) {
                        result = true;
                    }
                } else if (rbuf.length >= 3 && rbuf[2] == (byte)id) {
                    result = true;
                }
            }
            --trys;
        }
        return result;
    }

    private boolean delApplication(ComunicationObject co, int id) throws InterruptedException {
        boolean result = false;
        int trys = 10;
        byte[] sbuf = new byte[4];
        sbuf[0] = 4;
        sbuf[1] = 4;
        sbuf[2] = (byte)id;
        if (id >= 255) {
            sbuf[3] = (byte)(id / 256);
            co.setRequest(sbuf, 4);
        } else {
            co.setRequest(sbuf, 3);
        }
        while (trys > 0 && !result) {
            co.Prozess();
            byte[] rbuf = co.getAnser();
            if (rbuf != null) {
                if (rbuf.length >= 4) {
                    if (rbuf[2] == (byte)id & rbuf[3] == id / 256) {
                        result = true;
                    }
                } else if (rbuf.length >= 3 && rbuf[2] == (byte)id) {
                    result = true;
                }
            }
            --trys;
        }
        return result;
    }

    private boolean defaultApplication(ComunicationObject co) throws InterruptedException {
        boolean result = false;
        byte[] sbuf = new byte[]{4, 5, 0};
        co.setRequest(sbuf, 3);
        co.Prozess();
        byte[] rbuf = co.getAnser();
        if (rbuf != null && rbuf.length >= 3 && rbuf[2] == 0) {
            result = true;
        }
        return result;
    }

    private boolean WriteAllToFlash(ComunicationObject co) throws InterruptedException {
        boolean result = false;
        byte[] sbuf = new byte[]{4, 6, 0};
        co.setRequest(sbuf, 3);
        co.Prozess();
        byte[] rbuf = co.getAnser();
        if (rbuf != null && rbuf.length >= 3) {
            result = true;
        }
        return result;
    }

    private Application readApplicationFromMachine(ComunicationObject co, int id) throws InterruptedException {
        Application result = null;
        byte[] buffer = new byte[4];
        byte id1 = 0;
        byte id2 = 0;
        byte id3 = 0;
        boolean end1 = false;
        boolean end2 = false;
        boolean end3 = false;
        if (this.readApplication(co, id)) {
            result = new Application();
            while (!(end1 && end2 && end3 || this.stopTransfer)) {
                buffer[0] = 2;
                buffer[1] = id1;
                buffer[2] = id2;
                buffer[3] = id3;
                co.setRequest(buffer, 4);
                co.Prozess();
                byte[] buf = co.getAnser();
                if (buf != null) {
                    Parameter p = Utilities.convertByteArrayToParameter(buf);
                    if (p != null) {
                        result.addParameter(p);
                        end1 = false;
                        end2 = false;
                        end3 = false;
                    } else if (!end3) {
                        end3 = true;
                    } else if (!end2) {
                        end2 = true;
                    } else {
                        end1 = true;
                    }
                    if (end1) continue;
                    if (end2) {
                        id1 = (byte)(id1 + 1);
                        id2 = 0;
                        id3 = 0;
                        continue;
                    }
                    if (end3) {
                        id2 = (byte)(id2 + 1);
                        id3 = 0;
                        continue;
                    }
                    id3 = (byte)(id3 + 1);
                    continue;
                }
                result = null;
                end1 = true;
                end2 = true;
                end3 = true;
            }
        }
        if (this.stopTransfer) {
            result = null;
        }
        return result;
    }

    private Application blockreadApplicationFromMachine(ComunicationObject co, int id) throws InterruptedException {
        Application result = null;
        byte[] buffer = new byte[4];
        byte id1 = 0;
        byte id2 = 0;
        boolean end = false;
        if (this.readApplication(co, id)) {
            result = new Application();
            while (!end && !this.stopTransfer) {
                buffer[0] = 5;
                buffer[1] = id1;
                buffer[2] = id2;
                co.setRequest(buffer, 3);
                co.Prozess();
                byte[] buf = co.getAnser();
                if (buf != null) {
                    boolean end3;
                    byte id3 = 0;
                    do {
                        end3 = true;
                        Parameter p = Utilities.convertBlockByteArrayToParameter(buf, id3);
                        if (p == null) continue;
                        end3 = false;
                        result.addParameter(p);
                        id3 = (byte)(id3 + 1);
                    } while (!end3);
                    if (id3 > 0) {
                        id2 = (byte)(id2 + 1);
                        continue;
                    }
                    if (id2 > 0) {
                        id1 = (byte)(id1 + 1);
                        id2 = 0;
                        continue;
                    }
                    end = true;
                    continue;
                }
                result = null;
                end = true;
            }
        }
        if (this.stopTransfer) {
            result = null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readAllApplicationFromMachine(ComunicationObject co) throws InterruptedException {
        boolean result = true;
        Application a = null;
        this.data.clear();
        int i = 0;
        while (i <= this.data.getMaxNbrOfApplication()) {
            this.transfer(100 * i / this.data.getMaxNbrOfApplication(), String.valueOf(Messages.getString("MachineAccess.Applicatiom")) + i, true);
            if (i == 0) {
                if (this.currentApplicationEn) {
                    a = co.blockTransfer() ? this.blockreadApplicationFromMachine(co, 0) : this.readApplicationFromMachine(co, 0);
                    if (a != null) {
                        this.data.addApplication(0, a);
                    } else {
                        result = false;
                        break;
                    }
                }
            } else if (this.testApplication(co, i)) {
                a = co.blockTransfer() ? this.blockreadApplicationFromMachine(co, i) : this.readApplicationFromMachine(co, i);
                if (a != null) {
                    this.data.addApplication(i, a);
                } else {
                    result = false;
                    break;
                }
            }
            if (this.stopTransfer) {
                result = false;
                break;
            }
            ++i;
        }
        if (result) {
            this.Connection();
            return result;
        }
        if (this.stopTransfer) {
            this.TransferError(Messages.getString("MachineAccess.UserStopByReading"));
            return result;
        }
        this.TransferError(Messages.getString("MachineAccess.ComErrorByReading"));
        return result;
    }

    private boolean writeApplicationToMachine(ComunicationObject co, Application app, int id) throws InterruptedException {
        List pl;
        boolean result = false;
        boolean error = false;
        byte[] buffer = null;
        Parameter p = null;
        if (this.defaultApplication(co) && app != null && (pl = app.getParameterList()) != null && pl.size() > 0) {
            Iterator iterator = pl.iterator();
            while (iterator.hasNext() && !this.stopTransfer) {
                p = (Parameter)iterator.next();
                buffer = Utilities.convertParameterToByteArray((byte)3, p);
                if (buffer == null) continue;
                co.setRequest(buffer, buffer.length);
                co.Prozess();
                if (co.getAnser() != null) continue;
                error = true;
                break;
            }
            if (!this.stopTransfer && !error && this.writeApplication(co, id)) {
                result = true;
            }
        }
        return result;
    }

    private boolean blockwriteApplicationToMachine(ComunicationObject co, Application app, int id) throws InterruptedException {
        List pl;
        boolean result = false;
        boolean error = false;
        byte[] buffer = new byte[1000];
        byte[] tempbuffer = null;
        Parameter p = null;
        if (this.defaultApplication(co) && app != null && (pl = app.getParameterList()) != null && pl.size() > 0) {
            int index = 0;
            Iterator iterator = pl.iterator();
            while (iterator.hasNext() && !this.stopTransfer) {
                p = (Parameter)iterator.next();
                tempbuffer = Utilities.convertParameterToByteArray((byte)6, p);
                if (tempbuffer == null) continue;
                if (index > 0 && (buffer[1] != tempbuffer[1] || buffer[2] != tempbuffer[2])) {
                    buffer[index] = 0;
                    co.setRequest(buffer, ++index);
                    co.Prozess();
                    if (co.getAnser() == null) {
                        error = true;
                        break;
                    }
                    index = 0;
                }
                if (index == 0) {
                    buffer[0] = tempbuffer[0];
                    buffer[1] = tempbuffer[1];
                    buffer[2] = tempbuffer[2];
                    index = 3;
                }
                int i = 4;
                byte DataType = tempbuffer[i];
                while (i < tempbuffer.length) {
                    buffer[index] = tempbuffer[i];
                    ++index;
                    ++i;
                }
                if (DataType != 3) continue;
                buffer[index] = 0;
                ++index;
            }
            if (index > 0) {
                buffer[index] = 0;
                co.setRequest(buffer, ++index);
                co.Prozess();
                if (co.getAnser() == null) {
                    error = true;
                }
                index = 0;
            }
            if (!this.stopTransfer && !error && this.writeApplication(co, id)) {
                result = true;
            }
        }
        return result;
    }

    private boolean writeAllApplicationFromMachine(ComunicationObject co) throws InterruptedException {
        boolean result = true;
        Application a = null;
        int i = 0;
        while (i <= this.data.getMaxNbrOfApplication()) {
            if (i != 0 || this.currentApplicationEn) {
                this.transfer(100 * i / this.data.getMaxNbrOfApplication(), String.valueOf(Messages.getString("MachineAccess.Applicatiom")) + i, false);
                a = this.data.getApplication(i);
                if (a != null) {
                    if (co.blockTransfer()) {
                        if (!this.blockwriteApplicationToMachine(co, a, i)) {
                            result = false;
                            break;
                        }
                    } else if (!this.writeApplicationToMachine(co, a, i)) {
                        result = false;
                        break;
                    }
                } else if (i > 0) {
                    this.delApplication(co, i);
                }
            }
            if (this.stopTransfer) break;
            ++i;
        }
        if (!result) {
            if (this.stopTransfer) {
                this.TransferError(Messages.getString("MachineAccess.UserStopByWriting"));
            } else {
                this.TransferError(Messages.getString("MachineAccess.ComErrorByWritting"));
            }
        } else {
            this.WriteAllToFlash(co);
            this.Connection();
        }
        return result;
    }

    @Override
    public void run() {
        this.isTransferRunning = false;
        try {
            while (true) {
                if (!this.rm && !this.wm) {
                    Thread.sleep(100L);
                    continue;
                }
                this.stopTransfer = false;
                if (this.comObj.isPortOpen()) {
                    this.isTransferRunning = true;
                    if (this.rm) {
                        this.readAllApplicationFromMachine(this.comObj);
                        this.rm = false;
                    }
                    if (this.wm) {
                        this.writeAllApplicationFromMachine(this.comObj);
                        this.wm = false;
                    }
                    this.isTransferRunning = false;
                    continue;
                }
                this.rm = false;
                this.wm = false;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public void addMachineChangeListener(IMachineAccessListener listener) {
        this.machineListeners.add(listener);
    }

    public void removeMachineChangeListener(IMachineAccessListener listener) {
        this.machineListeners.remove(listener);
    }

    private void transfer(int percent, String txt, boolean direction) {
        this.isConnect = true;
        Iterator<IMachineAccessListener> iterator = this.machineListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().transferView(percent, txt, direction);
        }
    }

    private void noConnection() {
        this.isConnect = false;
        Iterator<IMachineAccessListener> iterator = this.machineListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().closeView();
        }
    }

    private void Connection() {
        this.isConnect = true;
        this.DataChanged();
        Iterator<IMachineAccessListener> iterator = this.machineListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().dataView();
        }
    }

    private void TransferError(String msg) {
        this.isConnect = true;
        this.DataChanged();
        Iterator<IMachineAccessListener> iterator = this.machineListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().transferErrorView(msg);
        }
    }

    public void abortTransfer() {
        this.stopTransfer = true;
    }

    public int getCommunicationNumber() {
        int result = 0;
        if (this.comObj != null) {
            result = this.comObj.getAddres();
        }
        return result;
    }

    public static enum STATE {
        EXIT,
        NO_COMMUNICATION,
        INIT,
        STOP,
        RUN,
        ERROR,
        EMERGENCY_STOP;

    }
}

