/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.ethernet;

import ch.uyuno.printcontrol.server.ethernet.EthernetUtilities;
import ch.uyuno.serialinterface.Frame;
import ch.uyuno.serialinterface.Framing;
import ch.uyuno.serialinterface.ISerialListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EthernetManager
implements Runnable {
    private final int MAX_BUFFER_SIZE = 512;
    private InputStream in;
    private OutputStream out;
    private boolean portOpen = false;
    private Socket clientSocket;
    private Framing serialFraming;
    private Set<ISerialListener> Listeners = new HashSet<ISerialListener>();
    private byte[] receiveBuffer = new byte[512];
    private static EthernetManager[] singelton = new EthernetManager[5];
    private EthernetUtilities.ERROR errorState;
    private byte Id;

    public static EthernetManager getEthernetManager(byte MessageId) {
        EthernetManager result = null;
        if (MessageId > 0 && MessageId <= 5) {
            if (singelton[MessageId - 1] == null) {
                Framing framing = new Framing();
                framing.SetCharStuf((byte)21, (byte)27);
                framing.SetChecksum(1);
                EthernetManager.singelton[MessageId - 1] = new EthernetManager(framing, MessageId);
            }
            result = singelton[MessageId - 1];
        }
        return result;
    }

    private EthernetManager(Framing framing, byte MessageId) {
        this.serialFraming = framing;
        this.Id = MessageId;
        new Thread((Runnable)this, "EthernetManager").start();
        this.errorState = EthernetUtilities.ERROR.INIT;
    }

    public boolean openPort(String IPAddress) {
        try {
            this.clientSocket = new Socket(IPAddress, 200);
            this.out = this.clientSocket.getOutputStream();
            this.out.flush();
            this.in = this.clientSocket.getInputStream();
            this.errorState = EthernetUtilities.ERROR.NONE;
            this.portOpen = true;
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("You are trying to connect to an unknown host!");
            this.errorState = EthernetUtilities.ERROR.NO_SUCH_HOST;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            System.err.println("No route To Host");
            this.errorState = EthernetUtilities.ERROR.NO_SUCH_HOST;
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            this.errorState = EthernetUtilities.ERROR.IN_USE;
        }
        return this.portOpen;
    }

    public boolean closePort() {
        if (this.isPortOpen()) {
            try {
                this.in.close();
                this.out.close();
                this.clientSocket.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            this.portOpen = false;
            this.errorState = EthernetUtilities.ERROR.NONE;
        }
        return !this.portOpen;
    }

    public boolean isPortOpen() {
        return this.portOpen;
    }

    public void send(Frame frame) {
        byte[] outputBytes = new byte[512];
        if (this.isPortOpen()) {
            frame.GetFrameBuffer()[0] = 1;
            this.serialFraming.InitTransmit(frame.GetFrameBuffer(), frame.GetFrameSize());
            int lenth = this.serialFraming.ToTransmit(outputBytes, 512);
            try {
                this.out.write(outputBytes, 0, lenth);
                this.out.flush();
            }
            catch (IOException iOException) {
                System.out.println("error: couldn't send string");
            }
        }
    }

    @Override
    public void run() {
        byte[] inByte = new byte[20];
        int size = 0;
        int res = 0;
        try {
            this.serialFraming.InitReceive(this.receiveBuffer, 512);
            while (true) {
                if (this.portOpen) {
                    try {
                        size = this.in.read(inByte, 0, 20);
                        res = this.serialFraming.FromReceive(inByte, size);
                        if (res <= 0) continue;
                        this.receive(new Frame(this.receiveBuffer, res));
                        this.serialFraming.InitReceive(this.receiveBuffer, 512);
                    }
                    catch (IOException e) {
                        System.out.println(e);
                    }
                    continue;
                }
                Thread.sleep(2L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    private void receive(Frame frame) {
        Iterator<ISerialListener> iterator = this.Listeners.iterator();
        frame.GetFrameBuffer()[0] = this.Id;
        while (iterator.hasNext()) {
            iterator.next().receive(frame);
        }
    }

    public void removeListener(ISerialListener Listener) {
        this.Listeners.remove(Listener);
    }

    public void addListener(ISerialListener Listener) {
        this.Listeners.add(Listener);
    }

    public EthernetUtilities.ERROR getError() {
        return this.errorState;
    }
}

