/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.views;

import ch.uyuno.printcontrol.server.Activator;
import ch.uyuno.printcontrol.server.ApplicationEntry;
import ch.uyuno.printcontrol.server.IDataAccessListener;
import ch.uyuno.printcontrol.server.IMachineAccessListener;
import ch.uyuno.printcontrol.server.MachineAccess;
import ch.uyuno.printcontrol.server.MachineControl;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.actions.DeleteApplicationAction;
import ch.uyuno.printcontrol.server.actions.RenameApplicationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class MachineApplicationListView
extends ViewPart
implements IMachineAccessListener {
    private int MachineID = -1;
    private MachineAccess control = null;
    private String fileName = "undefind.xml";
    private IDataAccessListener dataListener = null;
    private PageBook pagebook;
    private Composite compositeNoConnection;
    private Composite compositeConnection;
    private Composite compositeTransfer;
    private Composite compositeError;
    private int activeComposite;
    private String transferErrorValueText = "";
    private Label transferErrorTextLabel;
    private Label transferTextLabel;
    private Label transferImageLabel;
    private Image transferToMachine;
    private Image transferFromMachine;
    private ProgressBar transferProgressBar;
    private int transferValuePercent = 0;
    private String transferValueText = "";
    private boolean transferValueDirection = false;
    private TableViewer applicationTableViewer = null;
    private final String APP_NR_COLUMN = "nr";
    private final String APP_NAME_COLUMN = "name";
    private final String APP_NBR_OF_PAR_COLUMN = "nbrOfParameter";
    private String[] columnNames = new String[]{"nr", "name", "nbrOfParameter"};

    protected void finalize() {
        if (this.control != null) {
            if (this.dataListener != null) {
                this.control.removeDataChangeListener(this.dataListener);
                this.dataListener = null;
            }
            this.control.removeMachineChangeListener(this);
            this.control = null;
        }
    }

    public String GetFileName() {
        return this.fileName;
    }

    public void doExport(String fileName) {
        this.fileName = fileName;
        this.control.writeToFile(this.fileName);
    }

    public void doImport(String fileName) {
        this.fileName = fileName;
        this.control.readFromFile(fileName);
        this.applicationTableViewer.refresh();
    }

    public int ReadFromMachine() {
        int result = 0;
        if (!this.control.isTransferRunning()) {
            if (this.control.isConnect()) {
                this.control.readFromMachine();
            } else {
                result = 2;
            }
        } else {
            result = 1;
        }
        return result;
    }

    public int WriteToMachine() {
        int result = 0;
        if (!this.control.isTransferRunning()) {
            if (this.control.isConnect()) {
                if (!this.control.isEmpty()) {
                    this.control.writeToMachine();
                } else {
                    result = 3;
                }
            } else {
                result = 2;
            }
        } else {
            result = 1;
        }
        return result;
    }

    public void createPartControl(Composite parent) {
        int nr = 0;
        if (this.getViewSite().getSecondaryId() != null) {
            try {
                this.MachineID = Integer.parseInt(this.getViewSite().getSecondaryId());
            }
            catch (NumberFormatException numberFormatException) {
                this.MachineID = -1;
            }
            if (this.MachineID >= 0) {
                this.control = MachineControl.getMachineMainControl().GetMachineAccess(this.MachineID);
                nr = this.control.getCommunicationNumber();
            }
        }
        this.setPartName(String.valueOf(Messages.getString("MachineApplicationListView.Machine")) + nr);
        this.pagebook = new PageBook(parent, 0);
        this.compositeNoConnection = new Composite((Composite)this.pagebook, 0);
        this.createNoConnectionPage(this.compositeNoConnection);
        this.compositeConnection = new Composite((Composite)this.pagebook, 0);
        this.createConnectionPage(this.compositeConnection);
        this.compositeTransfer = new Composite((Composite)this.pagebook, 0);
        this.createTransferPage(this.compositeTransfer);
        this.compositeError = new Composite((Composite)this.pagebook, 0);
        this.createErrorPage(this.compositeError);
        if (this.MachineID >= 0 && this.control != null) {
            this.dataListener = new IDataAccessListener(){

                @Override
                public void DataChanged() {
                    Display d = PlatformUI.getWorkbench().getDisplay();
                    if (!d.isDisposed()) {
                        d.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MachineApplicationListView.this.applicationTableViewer != null && !MachineApplicationListView.this.applicationTableViewer.getControl().isDisposed()) {
                                    MachineApplicationListView.this.applicationTableViewer.refresh();
                                }
                            }
                        });
                    }
                }
            };
            this.control.addDataChangeListener(this.dataListener);
            this.control.addMachineChangeListener(this);
            this.pagebook.showPage((Control)this.compositeConnection);
            this.activeComposite = 1;
        } else {
            this.pagebook.showPage((Control)this.compositeNoConnection);
            this.activeComposite = 2;
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.applicationTableViewer);
    }

    private void createNoConnectionPage(Composite composite) {
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        label.setText(Messages.getString("NoConnectionToMachine"));
    }

    private void createErrorPage(Composite composite) {
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite row = new Composite(composite, 0);
        row.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 0, 0));
        row.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        row.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(row, 512);
        label.setAlignment(0x1000000);
        label.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 0, 0));
        label.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        label.setText(Messages.getString("MachineApplicationListView.TransferError"));
        this.transferErrorTextLabel = new Label(row, 512);
        this.transferErrorTextLabel.setAlignment(0x1000000);
        this.transferErrorTextLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 150, 150));
        this.transferErrorTextLabel.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        this.transferErrorTextLabel.setText("                                                                                                  ");
        Button sendButton = new Button(row, 0x1000008);
        sendButton.setText(Messages.getString("MachineApplicationListView.Reset"));
        sendButton.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        sendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MachineApplicationListView.this.pagebook.showPage((Control)MachineApplicationListView.this.compositeConnection);
                MachineApplicationListView.this.activeComposite = 1;
            }
        });
    }

    private void createConnectionPage(Composite parent) {
        parent.setLayout((Layout)new GridLayout(6, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 6, 5));
        this.createApplicationTable(composite);
    }

    private void createApplicationTable(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = 101124;
        Table applicationTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        applicationTable.setLayoutData((Object)gridData);
        applicationTable.setLinesVisible(true);
        applicationTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(applicationTable, 0x1000000, 0);
        column.setText(Messages.getString("FileApplicationListView.Id"));
        column.setToolTipText(Messages.getString("FileApplicationListView.ApplicationId"));
        column.setWidth(40);
        column = new TableColumn(applicationTable, 16384, 1);
        column.setText(Messages.getString("FileApplicationListView.Name"));
        column.setToolTipText(Messages.getString("FileApplicationListView.ApplicationName"));
        column.setWidth(150);
        column = new TableColumn(applicationTable, 0x1000000, 2);
        column.setText(Messages.getString("FileApplicationListView.Count"));
        column.setToolTipText(Messages.getString("FileApplicationListView.NbrOfParameter"));
        column.setWidth(50);
        this.applicationTableViewer = new TableViewer(applicationTable);
        this.applicationTableViewer.setColumnProperties(this.columnNames);
        this.applicationTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.applicationTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.applicationTableViewer.setSorter((ViewerSorter)new NameSorter());
        this.applicationTableViewer.setInput((Object)this.control);
        DragSource ds = new DragSource((Control)this.applicationTableViewer.getTable(), 2);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                String xml = "";
                int id = Integer.valueOf(MachineApplicationListView.this.applicationTableViewer.getTable().getSelection()[0].getText(0));
                if (MachineApplicationListView.this.control != null) {
                    xml = MachineApplicationListView.this.control.getApplicationAsXML(id);
                }
                event.data = xml;
            }
        });
        DropTarget dt = new DropTarget((Control)this.applicationTableViewer.getTable(), 2);
        dt.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                TableItem t = (TableItem)event.item;
                int id = Integer.valueOf(t.getText(0));
                String xml = (String)event.data;
                if (MachineApplicationListView.this.control != null && xml != null && id > 0) {
                    if (MachineApplicationListView.this.control.isApplicationValied(id)) {
                        if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("Confirm"), (String)Messages.getString("FileApplicationListView.ConfirmText"))) {
                            MachineApplicationListView.this.control.setApplicationAsXML(id, xml);
                        }
                    } else {
                        MachineApplicationListView.this.control.setApplicationAsXML(id, xml);
                    }
                }
                MachineApplicationListView.this.applicationTableViewer.refresh();
            }
        });
        DeleteApplicationAction deleteAction = new DeleteApplicationAction(Messages.getString("FileApplicationListView.DeleteMenu"), this.control);
        this.applicationTableViewer.addSelectionChangedListener((ISelectionChangedListener)deleteAction);
        deleteAction.selectionChanged((IStructuredSelection)this.applicationTableViewer.getSelection());
        RenameApplicationAction renameAction = new RenameApplicationAction(Messages.getString("FileApplicationListView.RenameMenu"), this.control);
        this.applicationTableViewer.addSelectionChangedListener((ISelectionChangedListener)renameAction);
        renameAction.selectionChanged((IStructuredSelection)this.applicationTableViewer.getSelection());
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IAction)deleteAction);
        contextMenuManager.add((IAction)renameAction);
        Menu contextMenu = contextMenuManager.createContextMenu((Control)this.applicationTableViewer.getTable());
        this.applicationTableViewer.getTable().setMenu(contextMenu);
    }

    private void createTransferPage(Composite composite) {
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite row = new Composite(composite, 0);
        row.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        row.setLayout((Layout)new GridLayout(1, false));
        this.transferImageLabel = new Label(row, 0x1000000);
        this.transferToMachine = Activator.getImageDescriptor("/icons/TransferToMachine.gif").createImage();
        this.transferFromMachine = Activator.getImageDescriptor("/icons/TransferFromMachine.gif").createImage();
        this.transferImageLabel.setImage(this.transferToMachine);
        this.transferImageLabel.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        this.transferTextLabel = new Label(row, 512);
        this.transferTextLabel.setAlignment(0x1000000);
        this.transferTextLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 127, 178, 127));
        this.transferTextLabel.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        this.transferProgressBar = new ProgressBar(row, 65536);
        this.transferProgressBar.setMinimum(0);
        this.transferProgressBar.setMaximum(100);
        this.transferProgressBar.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        Button abortButton = new Button(row, 0x1000008);
        abortButton.setText(Messages.getString("MachineApplicationListView.Abort"));
        abortButton.setLayoutData((Object)new GridData(4, 0x1000008, true, true, 1, 1));
        abortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MachineApplicationListView.this.control != null) {
                    MachineApplicationListView.this.control.abortTransfer();
                }
            }
        });
    }

    public void setFocus() {
        this.pagebook.setFocus();
    }

    @Override
    public void transferView(int percent, String txt, boolean direction) {
        this.transferValueText = txt;
        this.transferValuePercent = percent;
        this.transferValueDirection = direction;
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (MachineApplicationListView.this.activeComposite != 3 && !MachineApplicationListView.this.pagebook.isDisposed() && !MachineApplicationListView.this.compositeTransfer.isDisposed()) {
                        MachineApplicationListView.this.pagebook.showPage((Control)MachineApplicationListView.this.compositeTransfer);
                        MachineApplicationListView.this.compositeTransfer.setFocus();
                        MachineApplicationListView.this.activeComposite = 3;
                        if (MachineApplicationListView.this.transferValueDirection) {
                            MachineApplicationListView.this.transferImageLabel.setImage(MachineApplicationListView.this.transferFromMachine);
                        } else {
                            MachineApplicationListView.this.transferImageLabel.setImage(MachineApplicationListView.this.transferToMachine);
                        }
                    }
                    if (!MachineApplicationListView.this.transferTextLabel.isDisposed()) {
                        MachineApplicationListView.this.transferTextLabel.setText(MachineApplicationListView.this.transferValueText);
                    }
                    if (!MachineApplicationListView.this.transferProgressBar.isDisposed()) {
                        MachineApplicationListView.this.transferProgressBar.setSelection(MachineApplicationListView.this.transferValuePercent);
                    }
                }
            });
        }
    }

    @Override
    public void closeView() {
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MachineApplicationListView.this.pagebook.isDisposed() && !MachineApplicationListView.this.compositeNoConnection.isDisposed()) {
                        MachineApplicationListView.this.getViewSite().getPage().hideView((IViewPart)MachineApplicationListView.this);
                    }
                }
            });
        }
    }

    @Override
    public void dataView() {
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MachineApplicationListView.this.pagebook.isDisposed() && !MachineApplicationListView.this.compositeConnection.isDisposed() && MachineApplicationListView.this.activeComposite != 1 && MachineApplicationListView.this.activeComposite != 2) {
                        MachineApplicationListView.this.pagebook.showPage((Control)MachineApplicationListView.this.compositeConnection);
                        MachineApplicationListView.this.activeComposite = 1;
                    }
                }
            });
        }
    }

    @Override
    public void transferErrorView(String msg) {
        this.transferErrorValueText = msg;
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MachineApplicationListView.this.pagebook.isDisposed() && !MachineApplicationListView.this.compositeConnection.isDisposed()) {
                        MachineApplicationListView.this.pagebook.showPage((Control)MachineApplicationListView.this.compositeError);
                        MachineApplicationListView.this.transferErrorTextLabel.setText(MachineApplicationListView.this.transferErrorValueText);
                        MachineApplicationListView.this.activeComposite = 2;
                    }
                }
            });
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            return ((ApplicationEntry)o1).getNr() - ((ApplicationEntry)o2).getNr();
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return MachineApplicationListView.this.control.getApplicationNameArray();
        }
    }

    public class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            String result = "";
            ApplicationEntry entry = (ApplicationEntry)obj;
            switch (index) {
                case 0: {
                    result = "" + entry.getNr();
                    break;
                }
                case 1: {
                    result = entry.getName();
                    break;
                }
                case 2: {
                    result = "" + entry.getNbrOfParameter();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

