/*
 * Decompiled with CFR 0.152.
 */
package ch.uyuno.printcontrol.server.views;

import ch.uyuno.printcontrol.server.IMachineControlListener;
import ch.uyuno.printcontrol.server.MachineControl;
import ch.uyuno.printcontrol.server.Messages;
import ch.uyuno.printcontrol.server.widgets.MachineWidgets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class MachineControlView
extends ViewPart
implements IMachineControlListener {
    private PageBook pagebook;
    private Composite compositeNoConnection;
    private Composite compositeConnection;
    private Composite compositeSearch;
    private MachineControl.STATE state;
    private MachineControl machineControl;
    private int searchPercent;
    private String searchText;
    private Label searchLabel;
    private ProgressBar searchProgressBar;
    private boolean searchError;
    private MachineWidgets[] machineWidgets = new MachineWidgets[10];

    public MachineControlView() {
        this.machineControl = MachineControl.getMachineMainControl();
        this.machineControl.addChangeListener(this);
    }

    protected void finalize() {
        if (this.machineControl != null) {
            this.machineControl.removeChangeListener(this);
        }
    }

    public void createPartControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.compositeNoConnection = new Composite((Composite)this.pagebook, 0);
        this.createNoConnectionPage(this.compositeNoConnection);
        this.compositeConnection = new Composite((Composite)this.pagebook, 0);
        this.createConnectionPage(this.compositeConnection);
        this.compositeSearch = new Composite((Composite)this.pagebook, 0);
        this.createSearchPage(this.compositeSearch);
        this.pagebook.showPage((Control)this.compositeNoConnection);
    }

    public void setFocus() {
        this.pagebook.setFocus();
    }

    private void createSearchPage(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Composite c = new Composite(parent, 0x1000000);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        this.searchLabel = new Label(c, 512);
        this.searchLabel.setAlignment(0x1000000);
        this.searchLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 127, 178, 127));
        this.searchLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.searchLabel.setText("                                                                                            ");
        this.searchProgressBar = new ProgressBar(c, 65536);
        this.searchProgressBar.setMinimum(0);
        this.searchProgressBar.setMaximum(100);
        this.searchProgressBar.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
    }

    private void createConnectionPage(Composite parent) {
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.type = 256;
        layout.marginLeft = 4;
        layout.marginRight = 4;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.spacing = 4;
        parent.setLayout((Layout)layout);
        int i = 0;
        while (i < 10) {
            this.machineWidgets[i] = new MachineWidgets(parent, i, this.getViewSite().getWorkbenchWindow());
            ++i;
        }
    }

    private void createNoConnectionPage(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        label.setText(Messages.getString("NoConnectionToMachine"));
    }

    @Override
    public void changeState(MachineControl.STATE newState) {
        this.state = newState;
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Composite composite = MachineControlView.this.compositeNoConnection;
                    if (!composite.isDisposed()) {
                        if (MachineControlView.this.state == MachineControl.STATE.RUN) {
                            composite = MachineControlView.this.compositeConnection;
                            int i = 0;
                            while (i < 10) {
                                if (!MachineControlView.this.machineWidgets[i].isDisposed()) {
                                    MachineControlView.this.machineWidgets[i].refresh();
                                }
                                ++i;
                            }
                        } else if (MachineControlView.this.state == MachineControl.STATE.SEARCH) {
                            composite = MachineControlView.this.compositeSearch;
                            MachineControlView.this.searchLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 127, 178, 127));
                            MachineControlView.this.searchError = false;
                        }
                        if (!MachineControlView.this.pagebook.isDisposed() && !composite.isDisposed()) {
                            MachineControlView.this.pagebook.showPage((Control)composite);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void searchProgress(int percent, String text, boolean error) {
        this.searchPercent = percent;
        this.searchText = text;
        this.searchError = error;
        Display d = PlatformUI.getWorkbench().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MachineControlView.this.searchLabel.isDisposed()) {
                        MachineControlView.this.searchLabel.setText(MachineControlView.this.searchText);
                        if (MachineControlView.this.searchError) {
                            MachineControlView.this.searchLabel.setBackground(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 0, 0));
                        }
                    }
                    if (!MachineControlView.this.searchProgressBar.isDisposed()) {
                        MachineControlView.this.searchProgressBar.setSelection(MachineControlView.this.searchPercent);
                    }
                }
            });
        }
    }
}

