/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MSCryptoDSAPrivateKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public abstract class MSCryptoDSASignature
extends SignatureSpi {
    private MSCryptoDSAPrivateKey privateKey = null;

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] getDigest() throws SignatureException;

    protected abstract void resetDigest();

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof MSCryptoDSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MSCryptoDSAPrivateKey)privateKey;
        int n = this.privateKey.bitLength() + 7 >> 3;
        if (n < 64) {
            throw new InvalidKeyException("DSA keys should be at least 512 bits long");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.getDigest();
            byte[] byArray2 = MSCryptoDSASignature.nativeSignHash(byArray, byArray.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            byte[] byArray3 = new byte[20];
            byte[] byArray4 = new byte[20];
            System.arraycopy(byArray2, 0, byArray3, 0, 20);
            System.arraycopy(byArray2, 20, byArray4, 0, 20);
            BigInteger bigInteger = new BigInteger(this.convertEndianArray(byArray3));
            BigInteger bigInteger2 = new BigInteger(this.convertEndianArray(byArray4));
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray5 = derValue.toByteArray();
            return byArray5;
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Throwable throwable) {
            SignatureException signatureException = new SignatureException("Error generating signature.");
            signatureException.initCause(throwable);
            throw signatureException;
        }
        finally {
            this.resetDigest();
        }
    }

    protected static native byte[] nativeSignHash(byte[] var0, int var1, int var2, int var3) throws SignatureException;

    private byte[] convertEndianArray(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    public static final class NONEwithDSA
    extends MSCryptoDSASignature {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int offset;

        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            if (this.offset + n2 > 20) {
                this.offset = 21;
                return;
            }
            System.arraycopy(byArray, n, this.digestBuffer, this.offset, n2);
            this.offset += n2;
        }

        protected byte[] getDigest() throws SignatureException {
            if (this.offset != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.offset = 0;
            return this.digestBuffer;
        }

        protected void resetDigest() {
            this.offset = 0;
        }
    }

    public static class SHA1withDSA
    extends MSCryptoDSASignature {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        public SHA1withDSA() throws NoSuchAlgorithmException {
            this.dataSHA.reset();
        }

        protected void update(byte[] byArray, int n, int n2) {
            if (n2 == 0 || byArray == null) {
                return;
            }
            this.dataSHA.update(byArray, n, n2);
        }

        protected byte[] getDigest() {
            return this.dataSHA.digest();
        }

        protected void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

